export class IntRange implements Iterable<number> {
   public begin: number;

   public end: number;

   constructor(begin: number, end: number) {
      this.begin = Math.min(begin, end);
      this.end = Math.max(begin, end);
   }

   public toArray(): number[] {
      const array: number[] = [];
      for (const value of this) {
         array.push(value);
      }

      return array;
   }

   public [Symbol.iterator](): Iterator<number> {
      let current = this.begin - 1;
      return {
         next: () => {
            current += 1;
            return {
               done: current > this.end,
               value: current,
            };
         },
      };
   }
}
