export const getMapFromRecord = <K extends string, T>(record: Record<K, T>) =>
   new Map(Object.entries(record)) as Map<K, T>;

export const getRecordFromMap = <K extends string, T>(record: Map<K, T>) =>
   Object.fromEntries(record.entries()) as Record<K, T>;
