import { isEmpty } from '@yandex-infracloud-ui/libs';

export function nestedObjectValues(obj?: object | string): any[] {
   if (!obj) return [];
   if (typeof obj === 'string') {
      return [obj];
   }

   return Object.values(obj)
      .filter(val => !isEmpty(val))
      .map(val => {
         if (typeof val === 'object') {
            return nestedObjectValues(val);
         }

         return val;
      })
      .flat();
}
