export function omitMethods<T extends object>(obj: T): Partial<T> {
   const result: Partial<T> = {};

   for (const field in obj) {
      if (obj.hasOwnProperty(field) && typeof obj[field] !== 'function') {
         result[field] = obj[field];
      }
   }

   return result;
}
