export function pickFields<T extends object, F extends keyof T>(obj: T, keys: F[]): Pick<T, F> {
   return keys.reduce((acc, key) => {
      acc[key] = obj[key];

      return acc;
   }, {} as Pick<T, F>);
}
