import { deepClone } from '@yandex-infracloud-ui/libs';

export function setDefaultAndGet<O extends Record<string, any>, F extends keyof O>(
   obj: O,
   field: F,
   defaultValue: NonNullable<O[F]>,
): NonNullable<O[F]> {
   if (!obj.hasOwnProperty(field) || obj[field] === undefined || obj[field] === null) {
      obj[field] = deepClone(defaultValue);
   }

   return obj[field]!;
}
