import type { Dictionary } from '@reduxjs/toolkit';
import { toQuery } from '@yandex-infracloud-ui/libs';
import type * as H from 'history';

/**
 * Устанавливает новый Query, с записью действия в историю или нет
 *
 * @param history Объект history из react-router-dom
 * @param location Объект location из react-router-dom
 * @param params Словарь значений для search (сериализуется в URL внутри, заранее не надо!)
 * @param addToHistory Добавлять ли изменение query в историю браузера
 */
export function setUrlQuery(history: H.History, location: H.Location, params: Dictionary<any>, addToHistory: boolean) {
   const search = toQuery(params);
   if (search === location.search.replace(/^\?/, '')) {
      return;
   }

   const newLocation = { search };

   if (addToHistory) {
      history.push(newLocation);
   } else {
      history.replace(newLocation);
   }
}
