import { sortHandler } from '@yandex-infracloud-ui/libs';

export function sortObjectKeys(object: any) {
   if (typeof object !== 'object' || object === null) {
      return object;
   }

   return Object.keys(object)
      .sort((a, b) => sortHandler(a.toLowerCase(), b.toLowerCase()))
      .reduce((acc, key) => {
         const val = object[key];

         if (Array.isArray(val)) {
            acc[key] = val.map(sortObjectKeys);
         } else if (typeof val === 'object') {
            acc[key] = sortObjectKeys(val);
         } else {
            acc[key] = val;
         }

         return acc;
      }, {} as Record<string, any>);
}
