// inspired by https://github.com/hughsk/path-sort/blob/master/index.js

function sorter(a: string[], b: string[]): number {
   const maxLength = Math.max(a.length, b.length);
   for (let i = 0; i < maxLength; i += 1) {
      if (!(i in a)) {
         // console.log('index', a, b, 1);
         return -1;
      }
      if (!(i in b)) {
         // console.log('index', a, b, -1);
         return +1;
      }

      if (a[i].toLowerCase() > b[i].toLowerCase()) {
         // console.log('alpha', a, b, 1);
         return +1;
      }
      if (a[i].toLowerCase() < b[i].toLowerCase()) {
         // console.log('alpha', a, b, -1);
         return -1;
      }
   }

   return 0;
}

export function sortPaths(paths: string[], sep = '/') {
   return paths
      .map(el => el.split(sep))
      .sort(sorter)
      .map(el => el.join(sep));
}

/**
 * Оценочная функция для сортировки путей с вложенностями.
 *
 * Сначала отображается родитель, а затем его дети и дети детей.
 */
export function pathSorter(a: string, b: string, sep = '/') {
   return sorter(a.split(sep), b.split(sep));
}
