import { isEqual } from '@yandex-infracloud-ui/libs';
import { useEffect, useRef } from 'react';

/**
 * мемоизация списка по его значениям
 */
export function useArrayMemo<T>(list: T[]): T[] {
   const memoListRef = useRef(list);
   const isNew = !isEqual(memoListRef.current, list);
   useEffect(() => {
      // заменяем значение
      if (isNew) {
         memoListRef.current = list;
      }
   }, [isNew, list]);

   return isNew ? list : memoListRef.current;
}
