import { useCallback, useEffect } from 'react';

// from https://github.com/streamich/react-use/blob/master/src/useBeforeUnload.ts (unlicensed, public domain)
export function useBeforeUnload(enabled: boolean | (() => boolean) = true, message?: string) {
   const handler = useCallback(
      (event: BeforeUnloadEvent) => {
         const finalEnabled = typeof enabled === 'function' ? enabled() : true;

         if (!finalEnabled) {
            return undefined;
         }

         event.preventDefault();

         if (message) {
            event.returnValue = message;
         }

         return message;
      },
      [enabled, message],
   );

   useEffect(() => {
      if (!enabled) {
         return undefined;
      }

      window.addEventListener('beforeunload', handler);

      return () => window.removeEventListener('beforeunload', handler);
   }, [enabled, handler]);
}
