import { useEffect } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { storageMethods } from '../../old-code/store/reducers';
import type { RootState } from '../../redux';

export function useProjectAcl(projectId: string) {
   const dispatch = useDispatch();

   useEffect(() => {
      dispatch(storageMethods.deployAuth.getProjectAcl({ params: { projectId } }));
   }, [dispatch, projectId]);

   // без memo, каждый раз берем из redux
   const projectsAcl = useSelector((state: RootState) => storageMethods.deployAuth.selectProjectsAcl(state));

   return projectsAcl[projectId];
}
