import { useCallback, useEffect, useRef } from 'react';

export function useRafDelay(cb: (() => void) | undefined) {
   const rafRef = useRef<number>();

   useEffect(
      () => () => {
         if (rafRef.current) {
            window.cancelAnimationFrame(rafRef.current);
         }
      },
      [],
   );

   return useCallback(() => {
      if (cb) {
         rafRef.current = window.requestAnimationFrame(cb);
      }
   }, [cb]);
}
