import { useCallback, useRef } from 'react';

export function useSkipAfterFirstRender<T extends any[]>(
   action: (...args: T) => void,
   condition: (isFirst: boolean) => boolean,
) {
   const firstRender = useRef(true);
   const isAvailable = condition(firstRender.current);

   return useCallback(
      (...args: T) => {
         if (!isAvailable) {
            return;
         }
         if (!firstRender.current) {
            firstRender.current = false;
         }
         action(...args);
      },
      [action, isAvailable],
   );
}
