import { Meta } from '@storybook/react';
import React from 'react';

import { LegoButton } from '../../_lego';

import { useStateWithUpdaters } from './useStateWithUpdaters';

interface CounterState {
   count: number;
}

const updaters = {
   subtract(state: CounterState, value: number) {
      return {
         ...state,
         count: state.count - value,
      };
   },
   add(state: CounterState, value: number) {
      return {
         ...state,
         count: state.count + value,
      };
   },
};

const MyComponent = () => {
   const [state, stateUpdaters] = useStateWithUpdaters({ count: 0 }, updaters);
   return (
      <div>
         Count: {state.count}
         <br />
         <LegoButton onClick={() => stateUpdaters.subtract(1)}>-</LegoButton>
         <LegoButton onClick={() => stateUpdaters.add(1)}>+</LegoButton>
      </div>
   );
};

export const Regular = () => <MyComponent />;
Regular.storyName = 'useStateWithUpdaters';

export default {
   title: 'utils/hooks/useStateWithUpdaters',
} as Meta;
