import { useEffect, useState } from 'react';

/**
 * Выбрасывает ошибку, если значение поменялось
 * @param value отслеживаемое значение
 * @param message сообщение об ошибке
 */
export function useThrowIfChanged(value: any, message: string) {
   const [count, setCount] = useState(0);

   useEffect(() => {
      setCount(i => i + 1);
   }, [value]);

   useEffect(() => {
      if (count > 1) {
         console.warn(value);
         throw new Error(message);
      }
   }, [count, message, value]);
}
