import { RefObject, useCallback, useEffect } from 'react';

// Вызывает переданный коллбэк, когда расстояние от элемента ref до низа страницы меньше переданного лимита
export function useWindowScrollCallback(
   bottomDistanceLimit: number,
   ref: RefObject<HTMLElement> | null,
   callback?: () => void,
) {
   const action = useCallback(() => {
      if (ref?.current) {
         const { bottom } = ref.current.getBoundingClientRect();

         if (bottom - window.innerHeight < bottomDistanceLimit && callback) {
            callback();
         }
      }
   }, [bottomDistanceLimit, callback, ref]);

   useEffect(() => {
      window.addEventListener('scroll', action);

      return () => {
         window.removeEventListener('scroll', action);
      };
   }, [action]);
}
