import { parseYpDatetime } from './parsers';

describe('utils|parsers', () => {
   describe('parseYpDatetime', () => {
      it('should return null for empty', () => {
         expect(parseYpDatetime(null)).toBe(null);
         expect(parseYpDatetime(undefined)).toBe(null);
      });

      it('should parse without nanos', () => {
         expect(parseYpDatetime({ seconds: 1584377936 })).toEqual(new Date(1584377936000));
      });

      it('should parse with nanos', () => {
         expect(parseYpDatetime({ seconds: 1584377936, nanos: 147874000 })).toEqual(new Date(1584377936147.874));
      });
   });
});
