/**
 * Парсит странный формат timestamp в результатах запросов в YP
 */
import { isEmpty } from '@yandex-infracloud-ui/libs';

export function parseYpTimestamp(ts: number): Date {
   return new Date((ts / 2 ** 30) * 1000);
}

/**
 * Обычный ts, но в наносекундах
 */
export function parseSimpleYpTimestamp(ts: number): Date {
   return new Date(ts / 1000);
}

export interface ProtoDate {
   nanos?: number;
   seconds: number;
}

export function parseYpDatetime(v: ProtoDate | undefined | null): Date | null {
   if (isEmpty(v)) {
      return null;
   }

   return new Date(v!.seconds * 1000 + (v?.nanos ? v.nanos / 1e6 : 0));
}
