class BeepPlugin {
   apply(compiler) {
      const onCompileDone = () => this.beep();
      if (compiler.hooks) {
         compiler.hooks.done.tap('BeepPlugin', onCompileDone);
      } else {
         compiler.plugin('done', onCompileDone);
      }
   }

   beep() {
      console.log('\x07');
   }
}

module.exports = { BeepPlugin };
