const CircularDependencyPlugin = require('circular-dependency-plugin');
const { BeepPlugin } = require('./BeepPlugin');

module.exports = {
   addons: [
      '@storybook/addon-essentials',
      '@storybook/addon-links',
      '@storybook/addon-knobs',
      '@storybook/addon-options',
      '@storybook/preset-create-react-app',
   ],
   staticDirs: ['../public'],
   stories: ['../src/_storybook/intro.stories.mdx', '../src/**/*.stories.mdx', '../src/**/*.stories.@(js|jsx|ts|tsx)'],
   webpack: async config => {
      if (process.env.CHECK_CIRCULAR === 'true') {
         config.plugins.push(
            new CircularDependencyPlugin({
               // allow import cycles that include an asynchronous import,
               // e.g. via import(/* webpackMode: "weak" */ './file.js')
               allowAsyncCycles: false,
               // set the current working directory for displaying module paths
               cwd: process.cwd(),
               // exclude detection of files based on a RegExp
               exclude: /node_modules/,
               // add errors to webpack instead of warnings
               failOnError: false,
            }),
         );
      }

      if (process.env.BEEP === 'true') {
         config.plugins.push(new BeepPlugin());
      }

      return config;
   },
};
