# Библиотека `@yandex-infracloud-ui/libs`

## Библиотека будет расформирована (разрезана не множество более мелких)

Текущая библиотека слишком разрослась и нет большого смысла импортировать её целиком, если нужна только её часть.
Многие части довольно-таки самостоятельный и могут быть оформлены отдельными пакетами. Например, всё, связанное с формами.

[TOC]

## Назначение

Такое же, как у LEGO - унификация компонентов. Чтобы можно было быстро писать свои сервисы, используя готовый код.

В отличие от LEGO эти компоненты могут иметь довольно сложную логику. Например `actions` или `forms`. Это не кирпичики
приложения, а готовые блоки. Хотя "кирпичики" тоже есть.

## Быстрый старт

0. Если еще нет `.npmrc`, то создайте его:

```bash
echo "registry=http://npm.yandex-team.ru" > .npmrc
```

1. Установите саму библиотеку и зависимости:

```bash
npm i @yandex-infracloud-ui/libs rxjs react-router-dom
```

2. Подключите стили в `index.js` или `index.tsx` (точки старта приложения):

```javascript
import '@yandex-infracloud-ui/libs/dist/index.css';
```

3. Попробуйте использовать календарик:

```typescript jsx
import { DateTimePicker, json } from '@yandex-infracloud-ui/libs';
import React, { SyntheticEvent, useState } from 'react';
import './App.css';

function App() {
   // hooks
   const [value, setValue] = useState(new Date());

   // handlers
   const updateValue = (e: SyntheticEvent, v: Date) => setValue(v);

   // render
   return (
      <div style={{ maxWidth: '25rem', padding: '2rem' }}>
         <pre>{json(value)}</pre>
         <DateTimePicker value={value} onChange={updateValue} />
      </div>
   );
}

export default App;
```

Должно получиться так:

![](images/datetimepicker.png)
![](public/images/datetimepicker.png)

## Модули пакета

| Модуль             | Тип        | Назначение                                                                                                                  |
| :----------------- | :--------- | :-------------------------------------------------------------------------------------------------------------------------- |
| actions            | components | Помогает сформировать "действия" над одной или несколькими сущностями. Подробнее внутри.                                    |
| cookies            | service    | Сервисы для чтения и записи кук. Также сервис для чтения кук Яндекса (например, логина пользователя).                       |
| form_inputs        | components | Базовые контролы для форм, чаще всего обёртки над LEGO, добавляющие функциональности.                                       |
| formatters         | functions  | Чистые функции для форматирования данных: чисел, дат и т.п. Полезно для JSX. Аналог `pipe` в `Angular`                      |
| forms              | components | Набор компонентов для формирования форм в декларативном стиле.                                                              |
| helpers            | functions  | Чистые функции для частоиспользуемых операций. Альтернатива `lodash`                                                        |
| hotkeys            | service    | Позволяет добавить горячие клавиши глобально или на конкретную страницу.                                                    |
| http               | service    | Базовый класс для хождения в API. Умеет корректно распознавать ошибки, даже `nginx`, отменять запросы. Обёртка над `fetch`, |
| metrika            | functions  | Функция для подключения Яндекс.Метрика в проект по коду счётчика.                                                           |
| modals             | components | Для открытия модальных окон вызовом функции.                                                                                |
| react_hooks        | functions  | Набор кастомных хуков `use*` для свежего React                                                                              |
| small_components   | components | Разные мелкие компоненты, необходимые для любого проекта.                                                                   |
| suggestions        | components | Контролы для выбора сущностей из Staff API, ABC API и прочих "внешних" яндексовых сервисов.                                 |
| toasts             | service    | Всплывающие сообщения различных типов: информационных, ошибочных.                                                           |
| utils [deprecated] | functions  | Вспомогательные утилиты для написания кода React.                                                                           |

## Известные проблемы

1. Мало документации
2. Мало документации
3. Ну вы поняли, да?

## Планы на будущее

1. Перенести еще разных компонентов сюда.
2. _Неопределенно_: распилить на несколько npm пакетов (например DatePicker можно было бы использовать отдельно от
   всего, без необходимости тащить весь пакет).
3. Переписать `actions`, чтобы он использовал `modals`

## Разработка и контрибуция

### Используемые технологии

-  Язык - `TypeScript`
-  Фреймворк - `ReactJs v16.8`, `react-router`
-  Стили - `CSS Modules` без препроцессора (только постобработка `autoprefixer`)

### Вспомогательные библиотеки:

| Название     | Назначение                                                             |
| :----------- | :--------------------------------------------------------------------- |
| rxjs (peer)  | Управление потоками событий, паттерн `Observable`. Любая асинхронщина. |
| date-fns     | Утилиты для работы с датами (современная альтернатива `moment.js`)     |
| numeral      | Форматирование чисел                                                   |
| query-string | Парсинг GET-параметров (для роутинга)                                  |

### Контрибуция:

#### Требования к коду

TODO описать требования к коду, тестам, документации

#### Архитектура

TODO

#### Политика работы с зависимостями

TODO

#### Работа в репозитории

TODO описать принципы формирования веток, тегов, сообщения коммитов и т.п.

#### Добавление новых модулей

TODO

#### Выпуск релиза

TODO
