import { MinimalBlurEvent } from './MinimalBlurEvent';
import { MinimalChangeEvent } from './MinimalChangeEvent';

export interface MinimalFieldProps<V> {
   /**
    * поле в модели формы
    */
   name: string;

   /**
    * актуальное значение в поле
    */
   value: V;

   /**
    * функция, вызываемая при обновления значения изнутри поля (уведомление формы об изменениях)
    */
   onChange(e: MinimalChangeEvent<V>): void;

   /**
    * функция, вызываемая при уходе фокуса с формы.
    *
    * Когда это неактуально, можно её вызывать при первом изменении значения.
    * Требуется для правильной работы валидации.
    */
   onBlur(e: MinimalBlurEvent): void;
}
