function isFunction(f: any): boolean {
   return typeof f === 'function';
}

function hasMethod<T>(obj: T, method: string): boolean {
   return obj !== null && obj !== undefined && isFunction((obj as any)[method]);
}

export interface IClonable<T> {
   clone(): T;
}

export function isClonable<T>(obj: T | IClonable<T>): obj is IClonable<T> {
   return hasMethod(obj, 'clone');
}

export interface IEqualable<T> {
   isEqual(obj: T): boolean;
}

export function isEqualable<T>(obj: T | IEqualable<T>): obj is IEqualable<T> {
   return hasMethod(obj, 'isEqual');
}

export interface IJsonable {
   toJSON(): any;
}
