export const BYTES = {
   B: 1024 ** 0,
   KB: 1024 ** 1,
   MB: 1024 ** 2,
   GB: 1024 ** 3,
   TB: 1024 ** 4,
};

export const TIMES_IN_S = {
   Second: 1,
   Minute: 60,
   Hour: 60 * 60,
   Day: 60 * 60 * 24,
   Week: 60 * 60 * 24 * 7,
};

export const TIMES_IN_MS = {
   Millisecond: 1,
   Second: 1000 * TIMES_IN_S.Second,
   Minute: 1000 * TIMES_IN_S.Minute,
   Hour: 1000 * TIMES_IN_S.Hour,
   Day: 1000 * TIMES_IN_S.Day,
   Week: 1000 * TIMES_IN_S.Week,
};

export const DATEPICKER_FORMAT = 'dd.MM.yyyy';
export const TIMEPICKER_FORMAT = 'HH:mm';
export const TIMEPICKER_FORMAT_SEC = 'HH:mm:ss';

export const EMAIL_HOST = '@yandex-team.ru';

export const YT_EMAIL_REGEXP = /^\w([\w-]){0,38}\w@yandex-team\.ru$/;

export const PER_PAGE_VARIANTS = [25, 50, 100, 200];

export const PER_PAGE_DEFAULT = PER_PAGE_VARIANTS[1];

export const PER_PAGE_LOG = 150;

export const EMPTY_VALUE = '—';
