/**
 * focus - focusOptions - preventScroll polyfill for safari
 *
 * https://st.yandex-team.ru/WALLEUI-673
 *
 * original is https://github.com/calvellido/focus-options-polyfill
 * modified by khoden@yandex-team.ru
 */

let supportsPreventScrollOption = false;
try {
   const focusElem = document.createElement('div');
   focusElem.addEventListener(
      'focus',
      function (event) {
         event.preventDefault();
         event.stopPropagation();
      },
      true,
   );
   // document.documentElement.focus(
   focusElem.focus(
      Object.defineProperty({}, 'preventScroll', {
         // eslint-disable-next-line getter-return
         get() {
            supportsPreventScrollOption = true;
         },
      }),
   );
} catch (e) {}

if (HTMLElement.prototype.nativeFocus === undefined && !supportsPreventScrollOption) {
   HTMLElement.prototype.nativeFocus = HTMLElement.prototype.focus;

   HTMLElement.prototype.focus = function (args) {
      const actualPosition = window.scrollY || window.pageYOffset;
      this.nativeFocus();
      if (args && args.preventScroll) {
         // Hijacking the event loop order, since the focus() will trigger
         // internally an scroll that goes to the event loop
         setTimeout(function () {
            window.scroll(window.scrollX || window.pageXOffset, actualPosition);
         });
      }
   };
}
