import { faCheck } from '@fortawesome/free-solid-svg-icons/faCheck';
import { faTimes } from '@fortawesome/free-solid-svg-icons/faTimes';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Meta } from '@storybook/react';
import React from 'react';
import './index';

const polyfills = [
   { title: 'Promise.allSettled', supported: Boolean(Promise.allSettled) },
   // @ts-ignore
   { title: 'String.prototype.replaceAll', supported: Boolean(String.prototype.replaceAll) },
   // @ts-ignore
   { title: 'Array.prototype.flat', supported: Boolean(Array.prototype.flat) },
];

console.log({ polyfills });

export const AllPolyfills = () => {
   return (
      <table>
         <tbody>
            {polyfills.map(p => (
               <tr key={p.title}>
                  <th>{p.title}</th>
                  <td style={{ width: 40, textAlign: 'center' }}>
                     {p.supported ? (
                        <FontAwesomeIcon icon={faCheck} color={'green'} />
                     ) : (
                        <FontAwesomeIcon icon={faTimes} color={'red'} />
                     )}
                  </td>
               </tr>
            ))}
         </tbody>
      </table>
   );
};

export default {
   title: 'other/_polyfills',
} as Meta;
