import { action } from '@storybook/addon-actions';
import { Button } from '@yandex-cloud/uikit';
import { Form, Formik } from 'formik';
import * as React from 'react';

import { DevForm, DevFormValues } from '../../forms2';

export function formikDecorator<T>(initialValues: T) {
   return (Story: any) => (
      <Formik initialValues={initialValues} onSubmit={action('onSubmit')}>
         {() => (
            <Form>
               <Story />
               <div style={{ display: 'flex', gap: 12 }}>
                  <Button type={'reset'}>reset</Button>
                  <Button type={'submit'} view={'action'}>
                     submit
                  </Button>
               </div>
               <DevFormValues open={true} />
               <DevForm />
            </Form>
         )}
      </Formik>
   );
}
