import * as React from 'react';
import { CSSProperties } from 'react';

export function outlineDecorator(story: any) {
   const style: CSSProperties = {
      display: 'inline-block',
      outline: '1px dotted var(--color-gray)',
   };

   return <div style={style}>{story()}</div>;
}

export function fullWidthOutlineDecorator(story: any) {
   const style: CSSProperties = {
      outline: '1px dotted var(--color-gray)',
   };

   return <div style={style}>{story()}</div>;
}
