/* eslint-disable react/jsx-no-target-blank */

import { Meta } from '@storybook/react';
import * as React from 'react';

import { styleHelpers } from '../_styles/styleHelpers';
import { classNames, forHumanCapitalized, json } from '../formatters';

import colorPaletteStyles from './color_palette.module.css';
import cssModulesStyles from './css_modules.module.css';

const colors = ['red', 'orange', 'yellow', 'green', 'bluegreen', 'skyblue', 'blue', 'purple', 'pink'];

const grays = ['black', 'dark', 'dark-gray', 'gray', 'light-gray', 'light', 'white'];

function ColorPalette() {
   function ColorBlock(props: { color: string }) {
      return (
         <div className={colorPaletteStyles.block} style={{ backgroundColor: `var(${props.color})` }}>
            {props.color}
         </div>
      );
   }

   return (
      <>
         <section>
            <h3>Grays</h3>
            <article>
               <div className={colorPaletteStyles.horizontal}>
                  {grays.map(c => (
                     <ColorBlock key={c} color={`--color-${c}`} />
                  ))}
               </div>
            </article>
         </section>

         {colors.map(c => (
            <section key={c} className={colorPaletteStyles.section}>
               <h3>{forHumanCapitalized(c)}</h3>
               <article>
                  <div className={colorPaletteStyles.vertical}>
                     <ColorBlock color={`--color-${c}`} />
                     <div className={colorPaletteStyles.horizontal}>
                        <ColorBlock color={`--color-${c}-light`} />
                        <ColorBlock color={`--color-${c}-bright`} />
                        <ColorBlock color={`--color-${c}-dark`} />
                     </div>
                  </div>
               </article>
            </section>
         ))}
      </>
   );
}

export const Intro = () => <div />;

export const CSSModules = () => (
   <div className={cssModulesStyles.css_modules}>
      <a href={'https://github.com/css-modules/css-modules'} target={'_blank'} rel={'noopener noreferrer'}>
         CSS Modules
      </a>

      <pre>{json(cssModulesStyles)}</pre>

      <h2 className={cssModulesStyles.red}>RED</h2>
      <h2 className={cssModulesStyles.underline}>UNDERLINE</h2>
      <h2 className={cssModulesStyles.red_underline}>RED UNDERLINE</h2>
   </div>
);

export const GlobalStyles = () => <div className={'checkGlobalStyle'}>This text must be blue</div>;

export const StyleHelpers = () => (
   <>
      <ul className={styleHelpers.unstyledList}>
         <li>
            <div style={{ display: 'inline-block', outline: '1px solid red' }}>
               <a
                  href={'https://github.com/css-modules/css-modules'}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
                  className={styleHelpers.externalLink}
               >
                  CSS Modules
               </a>
               <a
                  href={'https://github.com/css-modules/css-modules'}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
                  className={styleHelpers.externalLink}
               >
                  CSS Modules
               </a>
               <a
                  href={'https://github.com/css-modules/css-modules'}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
                  className={styleHelpers.externalLink}
               >
                  CSS Modules
               </a>
               <a
                  href={'https://github.com/css-modules/css-modules'}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
                  className={styleHelpers.externalLink}
               >
                  CSS Modules
               </a>
               <a
                  href={'https://github.com/css-modules/css-modules'}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
                  className={styleHelpers.externalLink}
               >
                  CSS Modules
               </a>
               <a
                  href={'https://github.com/css-modules/css-modules'}
                  target={'_blank'}
                  rel={'noopener noreferrer'}
                  className={styleHelpers.externalLink}
               >
                  CSS Modules
               </a>
            </div>
         </li>
         <li>
            <a
               href={'https://github.com/css-modules/css-modules'}
               target={'_blank'}
               rel={'noopener noreferrer'}
               className={classNames(styleHelpers.externalGrayLink)}
            >
               CSS Modules
            </a>
         </li>
         <li>
            <a
               href={'https://github.com/css-modules/css-modules'}
               target={'_blank'}
               rel={'noopener noreferrer'}
               style={{ fontSize: '2rem' }}
               className={classNames(styleHelpers.externalLink)}
            >
               CSS Modules
            </a>
         </li>
         <li>
            <a href={'/'} className={styleHelpers.link}>
               Link
            </a>
         </li>
         <li>
            <a href={'/'} className={styleHelpers.linkGray}>
               Gray link
            </a>
         </li>
      </ul>

      <pre>{json(styleHelpers)}</pre>
   </>
);

export const regularStory = () => <ColorPalette />;
regularStory.storyName = 'Color Palette';

export default {
   title: 'other/Global Styles',
} as Meta;
