import { Observable, Subject } from 'rxjs';

import { IActionWithContext, IResultWithAction } from './models';

export class BaseActionService {
   public actions = new Subject<IActionWithContext<any>>();

   protected doAction<C>(subject: string, action: string, context: C): Observable<IResultWithAction<C>> {
      return new Observable(observer => {
         const actionWithContext: IActionWithContext<C> = {
            action,
            context,
            onComplete(results) {
               observer.next({ action, results });
               observer.complete();
            },
            onCancel() {
               observer.complete();
            },
            subject,
         };
         this.actions.next(actionWithContext);
      });
   }
}
