import { action } from '@storybook/addon-actions';
import { boolean, text } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { IAction } from '../models';

import { ActionButtons } from './ActionButtons';

const actions1: IAction[] = [
   { action: 'reboot', name: 'Reboot', important: true },
   { action: 'redeploy', name: 'Redeploy', important: true },
   { action: 'changeStatus', name: 'Change status', important: true },
   { action: 'profile', name: 'Profile', important: true },
   { action: 'switchProject', name: 'Switch project', important: true },
   { action: 'ikvm', name: 'iKVM', important: true },

   { action: 'other', name: 'Что-то еще', important: false },
   { action: 'other2', name: 'Что-то еще2', important: false },
   { action: 'other3', name: 'Что-то еще3', important: false },
];

const actions2: IAction[] = [
   { action: 'reboot', name: 'Reboot', important: true },
   { action: 'redeploy', name: 'Redeploy', important: true },
   { action: 'changeStatus', name: 'Change status', important: true },
];

const actions3: IAction[] = [{ action: 'reboot', name: 'Reboot', important: true }];

storiesOf('actions/ActionButtons', module)
   .add('full mode', () => (
      <ActionButtons
         actions={actions1}
         leftText={text('leftText', '')}
         disabled={boolean('disabled', false)}
         compact={boolean('compact', false)}
         onAction={action('onAction')}
         disabledActions={new Set(['reboot', 'other', 'changeStatus'])}
      />
   ))
   .add('compact mode', () => (
      <ActionButtons
         actions={actions2}
         leftText={text('leftText', '')}
         compact={boolean('compact', true)}
         onAction={action('onAction')}
         disabledActions={new Set(['reboot'])}
      />
   ))
   .add('one button', () => (
      <ActionButtons actions={actions3} compact={boolean('compact', true)} onAction={action('onAction')} />
   ));
