import { action } from '@storybook/addon-actions';
import { Meta } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useCallback } from 'react';
import { Observable, throwError, timer } from 'rxjs';
import { first, mapTo, switchMapTo } from 'rxjs/operators';

import { ModalLayout } from '../../modals';
import { BaseActionService } from '../base_action_service';
import { IActionStore, IActionWithModal, IBaseActionProps, IResultWithAction } from '../models';

import { ActionContainerEnhanced } from './ActionContainer';

function ModalContent({ onRun, onCancel }: IBaseActionProps<any>) {
   const close = useCallback(() => {
      const actions = Array(20)
         .fill(null)
         .map((_, i) => {
            const timeout = Math.random() * 2500;
            if (Math.random() > 0.1) {
               return timer(timeout).pipe(first(), mapTo({ id: i }));
            }
            // noinspection LongLine
            return timer(timeout).pipe(
               switchMapTo(
                  throwError({
                     errorMessage: `This is error message for #${i}`,
                  }),
               ),
            );
         });

      onRun(null, actions);
   }, [onRun]);
   const dismiss = useCallback(() => onCancel(null), [onCancel]);

   return (
      <ModalLayout onDismiss={dismiss} title={null} showFooter={false}>
         <Button view={'action'} onClick={close}>
            OK
         </Button>
         <Button onClick={dismiss}>Cancel</Button>
      </ModalLayout>
   );
}

/**
 * Список доступных действий
 *
 * Ради одного действия городить весь этот огород весьма нерационально.
 * Но если их число в перспективе будет расти, или их уже штук хотя бы 3-4, то уже имеет смысл заморочиться.
 */
const actions: IActionWithModal<any>[] = [
   { action: 'test1', name: 'Test 1', important: true, component: ModalContent },
];

class TestActionService extends BaseActionService {
   public do<C>(a: string, context: C): Observable<IResultWithAction<C>> {
      return this.doAction('testActions', a, context);
   }
}

const testActionService = new TestActionService();

const testActionStore: IActionStore = {
   testActions: {
      actions,
      resolveNameFromContext: () => ['test name'],
      service: testActionService,
   },
};

export function Regular() {
   // handlers
   const call = () => {
      testActionService.do('test1', null).subscribe(action('success'), action('cancel'));
   };

   return (
      <>
         <ActionContainerEnhanced actionStore={testActionStore} />

         <Button onClick={call}>Call test action</Button>
      </>
   );
}

export default {
   title: 'actions/ActionContainer',
} as Meta;
