import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import { Button, Dialog } from '@yandex-cloud/uikit';
import * as React from 'react';
import { useState } from 'react';
import { throwError, timer } from 'rxjs';
import { first, mapTo, switchMapTo } from 'rxjs/operators';

import { fullWidthOutlineDecorator } from '../../_storybook';

import { BatchProgress } from './BatchProgress';

interface IProps {
   count: number;
}

function BatchProgressStory({ count }: IProps) {
   const [visible, setVisible] = useState(false);

   const actions = Array(count)
      .fill(null)
      .map((_, i) => {
         const timeout = Math.random() * 250;
         if (Math.random() > 0.1) {
            return timer(timeout).pipe(first(), mapTo({ id: i }));
         }
         // noinspection LongLine
         return timer(timeout).pipe(
            switchMapTo(
               throwError({
                  errorMessage: `This is very very very very very very very very very very very very very very very very long error message for #${i}`,
               }),
            ),
         );
      });

   const names = Array(count)
      .fill(null)
      .map((_, i) => `Item #${i}`);

   const onClick = () => setVisible(true);

   return visible ? (
      <BatchProgress
         actions={actions}
         names={names}
         limit={5}
         canClose={boolean('canClose', false)}
         onClose={action('onClose')}
         onFinish={action('onFinish')}
      />
   ) : (
      <Button onClick={onClick}>Run {count} requests</Button>
   );
}

const BatchProgressModalStory = () => (
   <Dialog open={true} onClose={action('onOutsideClick')} hasCloseButton={false}>
      <BatchProgressStory count={1000} />
   </Dialog>
);

storiesOf('actions/BatchProgress', module)
   .addDecorator(fullWidthOutlineDecorator)
   .add('100 items', () => <BatchProgressStory count={100} />)
   .add('Modal', () => <BatchProgressModalStory />);
