/* eslint-disable react-hooks/exhaustive-deps */
// TODO переписать на useReducer, избавится от необходимости исключения линтера

import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { SyntheticEvent, useEffect, useReducer } from 'react';
import { Observable } from 'rxjs';
import { takeUntil } from 'rxjs/operators';

import { classNames, formatNumber, formatPercent } from '../../formatters';
import { noop } from '../../helpers';
import { ModalLayout } from '../../modals';
import { useDismounted } from '../../react_hooks';
import { Rows } from '../../small_components';
import { IResult } from '../models';

import classes from './BatchProgress.module.css';
import { ActionType, IItem, initialState, initState, ItemState, reducer } from './BatchProgress.state';

const Item = React.memo(
   ({ error, name, state }: IItem) => {
      return (
         <div
            className={classNames(classes.item, {
               [classes.enqueued]: state === ItemState.enqueued,
               [classes.process]: state === ItemState.process,
               [classes.failed]: state === ItemState.failed,
               [classes.success]: state === ItemState.success,
            })}
            title={state === ItemState.failed ? error : name}
         />
      );
   },
   (prev: IItem, next: IItem) => prev.state === next.state,
);

Item.displayName = 'Item';

interface IProps {
   actions: Observable<any>[];
   canClose: boolean;
   limit: number;
   names: string[];

   onClose(): void;

   onFinish(e: SyntheticEvent | null, result: IResult[]): void;
}

export const BatchProgress = React.memo(({ actions, canClose, limit, names, onFinish, onClose }: IProps) => {
   // region hooks
   const dismounted = useDismounted();

   const [{ items, restCount, errors }, dispatch] = useReducer(
      reducer,
      {
         ...initialState,
         actions,
         limit,
         names,
      },
      initState,
   );
   // endregion

   // region effects
   useEffect(() => {
      const processingCount = items.filter(item => item.state === ItemState.process).length;

      if (processingCount === limit) {
         return;
      }

      const itemsToRun = items.filter(item => item.state === ItemState.enqueued).slice(0, limit - processingCount);

      for (const item of itemsToRun) {
         dispatch({ type: ActionType.RunItem, item });
         item.action.pipe(takeUntil(dismounted)).subscribe(
            result => dispatch({ type: ActionType.Success, item, result }),
            result => dispatch({ type: ActionType.Failed, item, result }),
         );
      }
   }, [dismounted, items, limit]);

   useEffect(() => {
      if (restCount === 0) {
         dispatch({ type: ActionType.Finished, onFinish });
      }
   }, [onFinish, restCount]);
   // endregion

   // render
   const progress = actions.length > 0 ? (actions.length - restCount) / actions.length : 1;

   return (
      <ModalLayout
         onDismiss={canClose ? onClose : noop}
         title={
            <>
               Progress {formatPercent(progress, '0%')}
               <span className={classes.progress}>
                  ({formatNumber(actions.length - restCount)} of {formatNumber(actions.length)})
               </span>
               .
            </>
         }
         showFooter={false}
         customFooter={
            <Button view={'action'} onClick={onClose}>
               Close
            </Button>
         }
      >
         <div className={classes.batchProgress}>
            {items.map(item => (
               <Item key={item.name} {...item} />
            ))}
         </div>

         <div className={classes.errors}>
            <Rows text={errors} />
         </div>
      </ModalLayout>
   );
});

BatchProgress.displayName = 'BatchProgress';
