import { ComponentType, SyntheticEvent } from 'react';
import { Observable } from 'rxjs';

import { BaseActionService } from './base_action_service';

export interface IAction {
   action: string;

   important: boolean;
   name: string;
}

export interface IBaseActionProps<C> {
   context: C;

   meta?: IAction;

   onCancel(e: SyntheticEvent | null): void;

   onRun(e: SyntheticEvent | null, actions: Observable<any>[]): void;
}

export interface IActionWithContext<T> {
   action: string;
   context: T;
   subject: string;

   onComplete(results: IResult[]): void;

   onCancel(): void;
}

export interface IActionWithModal<T> extends IAction {
   component: ComponentType<T>;
}

export interface IResult<T = any> {
   response: T;
   success: boolean;
}

export interface IResultWithAction<T> {
   action: string;
   results: IResult<T>[];
}

export interface IActionStore {
   [subject: string]: {
      service: BaseActionService;
      actions: IActionWithModal<any>[];
      resolveNameFromContext(context: any): string[];
   };
}
