import { ICookiesParams, ICookieStore } from './models';

/**
 * Спёр из старой WALL-E UI
 */
export class Cookies {
   protected get(name: string): string {
      return this.parse(document.cookie)[name];
   }

   protected set(key: string, value: string, attributes?: Partial<ICookiesParams>) {
      let cookie = `${key}=${encodeURIComponent(value)}`;

      if (attributes) {
         for (const field in attributes) {
            if (attributes.hasOwnProperty(field)) {
               cookie += `;${field}=${attributes[field]}`;
            }
         }
      }

      document.cookie = cookie;
   }

   private parse(string: string): ICookieStore {
      const result: ICookieStore = {};

      string.split(';').forEach(pair => {
         const value = pair.trim().split('=');
         result[value[0]] = value.slice(1).join('=');
      });

      return result;
   }
}
