import { IconDefinition } from '@fortawesome/fontawesome-common-types';
import { Icon, IconProps } from '@yandex-cloud/uikit';
import React from 'react';

interface Props extends Omit<IconProps, 'data'> {
   icon: IconDefinition;
   size: number;
}

export function FontAwesomeDataUICommonIcon({ icon: { icon }, size, ...rest }: Props) {
   const [iconWidth, iconHeight, , , pathData] = icon;
   const iconMaxSize = Math.max(iconWidth, iconHeight);
   const scaleFactor = (size as number) / iconMaxSize;
   const path = `<path fill="currentColor" d="${pathData}" transform="scale(${scaleFactor})" />`;

   return <Icon data={path} size={size} {...rest} />;
}

// "Icon" component handles specially inside <Button/>
FontAwesomeDataUICommonIcon.displayName = 'Icon';
