import { Meta, Story } from '@storybook/react';
import { useState } from 'react';

import { SimpleSelect } from './SimpleSelect';

const Template: Story<{ initialValue: string; placeholder?: string }> = ({ initialValue, placeholder }) => {
   const [value, setValue] = useState(initialValue);

   return (
      <SimpleSelect
         items={[
            { value: 'a', title: 'AAA' },
            { value: 'b', title: 'BBB' },
         ]}
         placeholder={placeholder}
         value={value}
         onUpdate={setValue}
         switcherProps={{ style: { width: 200 } }}
      />
   );
};

export const Default = Template.bind({});
Default.args = { initialValue: 'a' };

export const EmptyWithPlaceholder = Template.bind({});
EmptyWithPlaceholder.args = { initialValue: '', placeholder: 'Select a value...' };

export const EmptyWithoutPlaceholder = Template.bind({});
EmptyWithoutPlaceholder.args = { initialValue: '' };

export default {
   title: 'data-ui-common-extra/SimpleSelect',
} as Meta;
