import { ComponentMeta, Story } from '@storybook/react';
import * as React from 'react';
import { useState } from 'react';

import { AutoGrowTextArea, AutoGrowTextAreaProps } from './AutoGrowTextArea';

const Template: Story<AutoGrowTextAreaProps> = props => {
   // hooks
   const [value, setValue] = useState('');

   // handlers
   const updateValue = (v: string) => setValue(v);

   // render
   return <AutoGrowTextArea value={value} onUpdate={updateValue} {...props} />;
};

export const Default = Template.bind({});
Default.args = {
   placeholder: 'Enter value',
   maxRows: 8,
   minRows: 1,
   rows: 2,
};

export default {
   component: AutoGrowTextArea,
   title: 'form_inputs/AutoGrowTextArea',
} as ComponentMeta<typeof AutoGrowTextArea>;
