import { TextInput, TextInputProps } from '@yandex-cloud/uikit';
import * as React from 'react';

import { minMax } from '../../helpers';

export interface AutoGrowTextAreaProps extends Partial<TextInputProps> {
   maxRows?: number;
   minRows?: number;
}

export const AutoGrowTextArea = React.memo(
   ({ maxRows = 20, minRows = 4, rows: oldRows, ...rest }: AutoGrowTextAreaProps) => {
      const value = rest.value || '';

      const rows = minMax(value.split('\n').length, oldRows || minRows, maxRows);

      return <TextInput multiline={true} rows={rows} {...rest} />;
   },
);

AutoGrowTextArea.displayName = 'AutoGrowTextArea';
