import { ComponentMeta, Story } from '@storybook/react';
import React, { useState } from 'react';

import { OptionalNumber } from '../../_models';
import { DevJson } from '../../small_components';

import { BytesInput, BytesInputProps } from './BytesInput';

const Template: Story<BytesInputProps> = props => {
   const [value, setValue] = useState<OptionalNumber>(props.value);

   return (
      <>
         <BytesInput {...props} name={'test'} value={value} onChange={setValue} />
         <DevJson open={true}>{value}</DevJson>
      </>
   );
};

export const Empty = Template.bind({});
Empty.args = { value: null };

export const Zero = Template.bind({});
Zero.args = { value: 0 };

export const Bytes = Template.bind({});
Bytes.args = { value: 200 };

export const Kilobytes = Template.bind({});
Kilobytes.args = { value: 1024 * 5 };

export const Megabytes = Template.bind({});
Megabytes.args = { value: 1024 * 1024 * 3 };

export const Gigabytes = Template.bind({});
Gigabytes.args = { value: 1024 * 1024 * 1024 * 3 };

export const HugeButNotRounding = Template.bind({});
HugeButNotRounding.args = { value: 1024 * 1024 * 3 + 200 * 1024 };

export default {
   args: {
      disabled: false,
      readonly: false,
   },
   component: BytesInput,
   title: 'form_inputs/BytesInput',
} as ComponentMeta<typeof BytesInput>;
