import React from 'react';

import { BaseInputProps, BYTES, OptionalNumber } from '../../_models';
import { formatNumber } from '../../formatters';
// noinspection ES6PreferShortImport
import { RoundedInput, RoundMeasure } from '../RoundedInput/RoundedInput';

const measures: RoundMeasure[] = [
   { name: 'Bytes', multiplier: BYTES.B },
   { name: 'KB', multiplier: BYTES.KB },
   { name: 'MB', multiplier: BYTES.MB },
   { name: 'GB', multiplier: BYTES.GB },
   { name: 'TB', multiplier: BYTES.TB },
];

export const renderDetails = (v: number) =>
   v >= 1024 ? `${formatNumber(v)} Bytes (~${formatNumber(v, '0.0 ib').replace('i', '')})` : `${formatNumber(v)} Bytes`;

export interface BytesInputProps extends BaseInputProps<OptionalNumber> {
   defaultMeasure?: string;
   useRenderDetails?: boolean;
}

export const BytesInput: React.FC<BytesInputProps> = React.memo(
   ({ useRenderDetails = true, defaultMeasure = 'GB', ...props }) => (
      <RoundedInput
         defaultMeasure={defaultMeasure}
         fixedWidth={75}
         measures={measures}
         renderDetails={renderDetails}
         useRenderDetails={useRenderDetails}
         {...props}
      />
   ),
);
