import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent, useCallback, useMemo, useState } from 'react';

import { narrowDecorator, routerDecorator } from '../../_storybook';
import { json } from '../../formatters';
import { autobind } from '../../utils';

import { CheckboxList } from './CheckboxList';
import { IListOption } from './models';

interface IProps {
   multiple: boolean;
}

class SmallCheckboxListStory extends React.PureComponent<IProps, { value: Set<string> }> {
   private options: IListOption[] = [
      {
         name: 'Testing 1',
         note: 'Belarus Belarus Belarus Belarus Belarus Belarus Belarus Belarus Belarus Belarus Belarus Belarus',
         value: 'by',
      },
      { name: 'Testing 2', note: 'Germany', value: 'de' },
      { name: 'Test project', value: 'fi' },
      { name: 'Тестовый проект', value: 'ру' },
   ];

   constructor(props: IProps) {
      super(props);

      this.state = {
         value: new Set(['by']),
      };
   }

   public render() {
      return (
         <>
            <CheckboxList
               multiple={this.props.multiple}
               options={this.options}
               value={this.state.value}
               onChange={this.onChange}
               getLinkHref={this.getLinkHref}
            />

            <pre>{json(this.state.value)}</pre>
         </>
      );
   }

   @autobind
   private getLinkHref(v: string) {
      return `/project/${v}`;
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private onChange(e: SyntheticEvent, value: Set<string>) {
      this.setState({ value });
   }
}

function BigMultiCheckboxListStory({ multiple, number }: { multiple: boolean; number: number }) {
   // hooks
   const options = useMemo(
      () =>
         Array(number)
            .fill(null)
            .map(
               (_, i) =>
                  ({
                     name: `item_${i}`,
                     value: `item_${i}`,
                  } as IListOption),
            ),
      [number],
   );

   const [value, setValue] = useState(new Set(['item_1']));

   // handlers
   const updateValue = useCallback((e: SyntheticEvent | null, v: Set<string>) => setValue(v), []);

   // render
   return (
      <div style={{ display: 'flex' }}>
         <CheckboxList options={options} value={value} multiple={multiple} onChange={updateValue} />

         <pre>{json(value)}</pre>
      </div>
   );
}

storiesOf('form_inputs/CheckboxList', module)
   .addDecorator(routerDecorator)
   .addDecorator(narrowDecorator)
   .add('small single', () => <SmallCheckboxListStory multiple={false} />)
   .add('small multi', () => <SmallCheckboxListStory multiple={true} />)
   .add('big multi', () => <BigMultiCheckboxListStory multiple={true} number={1000} />);
