import { storiesOf } from '@storybook/react';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import { json } from '../../formatters';
import { autobind } from '../../utils';

import { CheckboxTree } from './CheckboxTree';
import { ITreeOption } from './models';

class CheckboxTreeStory extends React.PureComponent<{}, { value: Set<string> }> {
   // noinspection SpellCheckingInspection
   private options: ITreeOption[] = [
      {
         children: [{ value: 'msq', name: 'MSQ' }],
         name: 'BY',
         note: 'Belarus',
         value: 'by',
      },
      {
         children: [
            { value: 'berlin', name: 'BERLIN' },
            { value: 'frnm', name: 'FRNM' },
         ],
         name: 'DE',
         note: 'Germany',
         value: 'de',
      },
      {
         children: [
            { value: 'helsinki', name: 'HELSINKI' },
            {
               children: [
                  { value: 'a', name: 'A' },
                  {
                     children: [
                        {
                           children: [
                              { value: 'bn1-2', name: 'BN1-2' },
                              { value: 'bn1-4', name: 'BN1-4' },
                              { value: 'bn1-6', name: 'BN1-6' },
                              { value: 'bn1-7', name: 'BN1-7' },
                           ],
                           name: 'CC-1.1#B.1.45',
                           value: 'cc-1.1#b.1.45',
                        },
                        { value: 'man-1#b.1.06', name: 'MAN-1#B.1.06' },
                        { value: 'man-1#b.1.07', name: 'MAN-1#B.1.07' },
                        { value: 'man-1#b.1.08', name: 'MAN-1#B.1.08' },
                        { value: 'man-1#b.1.09', name: 'MAN-1#B.1.09' },
                        { value: 'man-1#b.1.10', name: 'MAN-1#B.1.10' },
                     ],
                     name: 'B',
                     value: 'b',
                  },
               ],
               name: 'MANTSALA',
               value: 'mantsala',
            },
         ],
         name: 'FI',
         value: 'fi',
      },
   ];

   constructor(props: {}) {
      super(props);

      this.state = {
         value: new Set(['bn1-4', 'bn1-6', 'man-1#b.1.08']),
      };
   }

   public render() {
      return (
         <>
            <CheckboxTree options={this.options} value={this.state.value} onChange={this.onChange} />
            Selected: <pre>{json(this.state.value)}</pre>
            Options: <pre>{json(this.options)}</pre>
         </>
      );
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private onChange(e: SyntheticEvent, value: Set<string>) {
      this.setState({ value });
   }
}

storiesOf('form_inputs/CheckboxTree', module).add('regular', () => <CheckboxTreeStory />);
