import { getExpanded, ITreeOption } from './models';

describe('small_components/CheckboxTree/models', () => {
   describe('getExpanded', () => {
      it('expanded by default (empty)', () => {
         const options: ITreeOption[] = [];
         const selected = new Set([]);

         expect(getExpanded(options, selected)).toEqual(new Set([]));
      });

      it('expanded by default (one level)', () => {
         const options: ITreeOption[] = [
            { value: 'item1', name: 'item1', children: [{ value: 'item1.1', name: 'item1.1' }] },
         ];
         const selected = new Set(['item1.1']);

         expect(getExpanded(options, selected)).toEqual(new Set(['item1']));
      });

      it('expanded by default (two levels)', () => {
         const options: ITreeOption[] = [
            {
               children: [
                  {
                     children: [
                        { value: 'item1.1.1', name: 'item1.1.1' },
                        { value: 'item1.1.2', name: 'item1.1.2' },
                        { value: 'item1.1.3', name: 'item1.1.3' },
                     ],
                     name: 'item1.1',
                     value: 'item1.1',
                  },
               ],
               name: 'item1',
               value: 'item1',
            },
         ];
         const selected = new Set(['item1.1.3']);

         const actual = Array.from(getExpanded(options, selected)).sort();
         const expected = Array.from(new Set(['item1', 'item1.1'])).sort();
         expect(actual).toEqual(expected);
      });
   });
});
