// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { IListOption } from '../CheckboxList/models';

function hasSelectedChild(option: ITreeOption, selected: Set<string>, expanded: Set<string>): boolean {
   if (!option.children) {
      return false;
   }

   return option.children.some(child => {
      const hasSelectedChild2 = selected.has(child.value) || hasSelectedChild(child, selected, expanded);

      if (hasSelectedChild2) {
         expanded.add(option.value);
      }

      return hasSelectedChild2;
   });
}

export interface ITreeOption extends IListOption {
   children?: ITreeOption[];
}

/**
 * FIXME требует рефакторинга, expanded не нужно передавать в функцию hasSelectedChild и "загрязнять" её
 */
export function getExpanded(options: ITreeOption[], selected: Set<string>): Set<string> {
   const expanded = new Set<string>();

   for (const option of options) {
      if (hasSelectedChild(option, selected, expanded)) {
         expanded.add(option.value);
      }
   }

   return expanded;
}
