import { action } from '@storybook/addon-actions';
import { boolean, date } from '@storybook/addon-knobs';
import { storiesOf } from '@storybook/react';
import * as React from 'react';

import { narrowDecorator, outlineDecorator } from '../../_storybook';

import { DateRangePicker } from './DateRangePicker';

storiesOf('form_inputs/DateRangePicker', module)
   .addDecorator(outlineDecorator)
   .addDecorator(narrowDecorator)
   .add('regular', () => (
      <DateRangePicker
         from={date('from', null as any) as any}
         to={date('to', null as any) as any}
         withTime={boolean('withTime', true)}
         onFromChange={action('onFromChange')}
         onToChange={action('onToChange')}
      />
   ));
