import isAfter from 'date-fns/isAfter';
import * as React from 'react';
import { SyntheticEvent } from 'react';

import { NullableDate } from '../../_models';
import { isEqual } from '../../helpers';
import { autobind } from '../../utils';
// noinspection TypeScriptPreferShortImport,ES6PreferShortImport
import { DateTimePicker, DefaultTime } from '../DateTimePicker/DateTimePicker';

import styles from './DateRangePicker.module.css';

interface IProps {
   from: NullableDate;
   to: NullableDate;
   withTime?: boolean;

   onFromChange(e: null, v: NullableDate): void;

   onToChange(e: null, v: NullableDate): void;
}

export class DateRangePicker extends React.PureComponent<IProps> {
   public static defaultProps = {
      withTime: false,
   };

   constructor(props: IProps) {
      super(props);

      this.state = {};
   }

   public render() {
      return (
         <div className={styles.dateRangePicker}>
            <DateTimePicker
               placeholder={'From'}
               cls={styles.picker}
               value={this.props.from}
               onChange={this.onFromChange}
               withTime={this.props.withTime}
               defaultTimeMode={DefaultTime.StartOfDay}
            />
            <DateTimePicker
               placeholder={'To'}
               cls={styles.picker}
               value={this.props.to}
               onChange={this.onToChange}
               withTime={this.props.withTime}
               defaultTimeMode={DefaultTime.EndOfDay}
            />
         </div>
      );
   }

   @autobind
   public onFromChange(e: SyntheticEvent, from: NullableDate): void {
      this.onChange(from, this.props.to);
   }

   private change(params: { from: NullableDate; to: NullableDate }): void {
      if (!isEqual(this.props.from, params.from)) {
         this.props.onFromChange(null, params.from);
      }

      if (!isEqual(this.props.to, params.to)) {
         this.props.onToChange(null, params.to);
      }
   }

   private onChange(from: NullableDate, to: NullableDate): void {
      if (from !== null && to !== null && isAfter(from, to)) {
         this.change({ from: to, to: from }); // меняю местами
      } else {
         this.change({ from, to });
      }
   }

   // noinspection JSUnusedLocalSymbols
   @autobind
   private onToChange(e: SyntheticEvent, to: NullableDate): void {
      this.onChange(this.props.from, to);
   }
}
