import { action } from '@storybook/addon-actions';
import { boolean } from '@storybook/addon-knobs';
import { Meta } from '@storybook/react';
import { Button } from '@yandex-cloud/uikit';
import * as React from 'react';
import { SyntheticEvent, useState } from 'react';

import { narrowDecorator } from '../../_storybook';
import { json } from '../../formatters';

import { DateTimePicker } from './DateTimePicker';

interface IProps {
   showTimeString?: boolean;
   withSeconds?: boolean;
   withTime: boolean;
}

const onChangeAction = action('onChange');

const DateTimePickerStory = ({ withTime, showTimeString = false, withSeconds = false }: IProps) => {
   // hooks
   const [value, setValue] = useState<Date | null>(null);

   // handlers
   const updateValue = (e: SyntheticEvent | null, v: Date) => {
      setValue(v);
      onChangeAction(v);
   };

   // render
   return (
      <>
         <Button onClick={() => setValue(null)}>Set null</Button>

         <Button onClick={() => setValue(new Date())}>Set now</Button>

         <DateTimePicker
            value={value}
            disabled={boolean('disabled', false)}
            showTimeString={boolean('showTimeString', showTimeString)}
            onChange={updateValue}
            withTime={withTime}
            withSeconds={withSeconds}
         />
         <pre>{json(value)}</pre>
      </>
   );
};

export const OnlyDate = () => <DateTimePickerStory withTime={false} />;

export const WithTime = () => <DateTimePickerStory withTime={true} />;

export const WithShowTimeString = () => <DateTimePickerStory withTime={true} showTimeString={true} />;

export const WithSeconds = () => <DateTimePickerStory withTime={true} showTimeString={true} withSeconds={true} />;

export default {
   decorators: [narrowDecorator],
   title: 'form_inputs/DateTimePicker',
} as Meta;
